/*******************************************************************
*
*  DESCRIPTION: Atomic Model Sonar1
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 07/08/2009
*
*******************************************************************/

#ifndef __SONAR1_H
#define __SONAR1_H

/** include files **/
#include "atomic.h"     // class Atomic
#include "string.h"	// class String

/** declarations **/
class LightSensor : public Atomic
{
public:
	LightSensor( const std::string &name = "LightSensor" ); //Default constructor
	virtual std::string className() const {  return "LightSensor" ;}
	~LightSensor();


protected:

	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &ls_light_in, &ls_start_in;
	Port &ls_light_out;
	
	Time lsTxTime;	//Data Tx time_advance

	int light_input; // value of port
	enum State{         //to keep current state of the LightSensor
		IDLE,
		DETECTING,      //waiting an input
		TX_DATA       // something founded send output to radar
	} state;

};	// class LightSensor

#endif   //__SONAR1_H
